require 'time'

find = /### ([0-9.]+) (.*)/

me = File.expand_path(__FILE__)

Dir["./CHANGELOG.md"].each do |f|
  begin
    next unless File.file?(f)
    next if me == File.expand_path(f)
    contents = File.read(f)
    next unless contents =~ find
    puts f
    File.open(f, 'w') do |f|
      contents = contents.gsub(find) { |match|
        t = Time.parse($2)
        "## #{$1} - #{t.strftime("%Y-%m-%d")}"
      }
      f.puts(contents)
    end
  rescue ArgumentError
    raise unless $!.message =~ /invalid byte sequence in UTF-8/
  end
end
